/** @file   menulevelchange.h
 * @brief   Declaraction of MenuLevelChange - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MENULEVELCHANGE_H
#define H_WWW_MENULEVELCHANGE_H

#include "Font.h"
#include "menupage.h"

namespace WeWantWar {


/** @class  MenuLevelChange
 * @brief   This menu is shown between the levels.
 * @author  Tomi Lamminsaari
 */
class MenuLevelChange : public MenuPage
{
public:

  ///
  /// Static members and methods
  /// ==========================
  
  /** ID of the PLAY LEVEL - option */
  static const int PLAY_LEVEL = 0;
  /** ID of the SAVE GAME - option */
  static const int SAVE_GAME = 1;
  /** ID of the MAINMENU  - option */
  static const int BACK_TO_MAINMENU = 2;
  


  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Constructor.
   */
  MenuLevelChange();
  
  /** Destructor.
   */
  virtual ~MenuLevelChange();
  
  

  ///
  /// Public methods
  /// ==============
  
  /** Updates this menupage. Checks the keyboard controls and
   * informs the caller, when it's time to change menupages.
   * @return    PLAY_LEVEL = Player wants to play next level. SAVE_GAME =
   *            We should show the SaveGame-screen or BACK_TO_MAINMENU =
   *            Player wants to go back to main menu.
   */
  virtual int update();
  
  /** Redraws the contents of this menupage to background buffer.
   */
  virtual void redraw();
  
  
  /** Sets the level-id that we should show in the top of this menupage.
   * @param     levelnum          Index of the next level.
   */
  void setLevelNum( int levelnum );



  ///
  /// Public GET-methods
  /// ==================
  
  /** Returns the ID-code of this menupage.
   * @return    MenuPage::LEVELCHANGE
   */
  virtual MenuPage::PageID getPageID() const { return MenuPage::LEVELCHANGE; }
  
  
protected:

  /** Handles the cases when player pressed ENTER-key and tells if the menupage
   * should be changed.
   * @return    MenuPage::NO_PAGE_CHANGE or MenuPage::PAGE_CHANGE
   */
  int checkEnterKey();
  
  /** Creates the help-notes
   */
  void createHelpNotes();
  
  
  
  ///
  /// Members
  /// =======
  
  /** The index of the next level. */
  int             m_levelnum;
  

private:

  /** Private methods **/
  
  MenuLevelChange(const MenuLevelChange& rO);
  MenuLevelChange& operator = (const MenuLevelChange& rO);
};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: menulevelchange.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:02+02  lamminsa
 * Initial revision
 *
 */
 
